package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString,
    tags: Iterable[zio.aws.chime.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TagAttendeeRequest = {
    import TagAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TagAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TagAttendeeRequest.ReadOnly =
    zio.aws.chime.model.TagAttendeeRequest.wrap(buildAwsValue())
}
object TagAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TagAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TagAttendeeRequest =
      zio.aws.chime.model.TagAttendeeRequest(
        meetingId,
        attendeeId,
        tags.map { item =>
          item.asEditable
        }
      )
    def meetingId: GuidString
    def attendeeId: GuidString
    def tags: List[zio.aws.chime.model.Tag.ReadOnly]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.chime.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TagAttendeeRequest
  ) extends zio.aws.chime.model.TagAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.attendeeId())
    override val tags: List[zio.aws.chime.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.chime.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TagAttendeeRequest
  ): zio.aws.chime.model.TagAttendeeRequest.ReadOnly = new Wrapper(impl)
}
