package zio.aws.chime.model
import zio.aws.chime.model.primitives.GuidString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagMeetingRequest(
    meetingId: GuidString,
    tags: Iterable[zio.aws.chime.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TagMeetingRequest = {
    import TagMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TagMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TagMeetingRequest.ReadOnly =
    zio.aws.chime.model.TagMeetingRequest.wrap(buildAwsValue())
}
object TagMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TagMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TagMeetingRequest =
      zio.aws.chime.model.TagMeetingRequest(
        meetingId,
        tags.map { item =>
          item.asEditable
        }
      )
    def meetingId: GuidString
    def tags: List[zio.aws.chime.model.Tag.ReadOnly]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getTags: ZIO[Any, Nothing, List[zio.aws.chime.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TagMeetingRequest
  ) extends zio.aws.chime.model.TagMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val tags: List[zio.aws.chime.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.chime.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TagMeetingRequest
  ): zio.aws.chime.model.TagMeetingRequest.ReadOnly = new Wrapper(impl)
}
