package zio.aws.chime.model
import zio.aws.chime.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceARN: Arn,
    tags: Iterable[zio.aws.chime.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TagResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TagResourceRequest.ReadOnly =
    zio.aws.chime.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TagResourceRequest =
      zio.aws.chime.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: Arn
    def tags: List[zio.aws.chime.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
    def getTags: ZIO[Any, Nothing, List[zio.aws.chime.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TagResourceRequest
  ) extends zio.aws.chime.model.TagResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.chime.model.primitives.Arn(impl.resourceARN())
    override val tags: List[zio.aws.chime.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.chime.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TagResourceRequest
  ): zio.aws.chime.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
