package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TelephonySettings(
    inboundCalling: Boolean,
    outboundCalling: Boolean,
    sms: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TelephonySettings = {
    import TelephonySettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TelephonySettings
      .builder()
      .inboundCalling(inboundCalling: java.lang.Boolean)
      .outboundCalling(outboundCalling: java.lang.Boolean)
      .sms(sms: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TelephonySettings.ReadOnly =
    zio.aws.chime.model.TelephonySettings.wrap(buildAwsValue())
}
object TelephonySettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TelephonySettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TelephonySettings = zio.aws.chime.model
      .TelephonySettings(inboundCalling, outboundCalling, sms)
    def inboundCalling: Boolean
    def outboundCalling: Boolean
    def sms: Boolean
    def getInboundCalling: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(inboundCalling)
    def getOutboundCalling: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(outboundCalling)
    def getSms: ZIO[Any, Nothing, Boolean] = ZIO.succeed(sms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TelephonySettings
  ) extends zio.aws.chime.model.TelephonySettings.ReadOnly {
    override val inboundCalling: Boolean = impl.inboundCalling(): Boolean
    override val outboundCalling: Boolean = impl.outboundCalling(): Boolean
    override val sms: Boolean = impl.sms(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TelephonySettings
  ): zio.aws.chime.model.TelephonySettings.ReadOnly = new Wrapper(impl)
}
