package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.Iso8601Timestamp
import scala.jdk.CollectionConverters._
final case class TerminationHealth(
    timestamp: Optional[Iso8601Timestamp] = Optional.Absent,
    source: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TerminationHealth = {
    import TerminationHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TerminationHealth
      .builder()
      .optionallyWith(
        timestamp.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.timestamp)
      .optionallyWith(source.map(value => value: java.lang.String))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TerminationHealth.ReadOnly =
    zio.aws.chime.model.TerminationHealth.wrap(buildAwsValue())
}
object TerminationHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TerminationHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TerminationHealth =
      zio.aws.chime.model.TerminationHealth(
        timestamp.map(value => value),
        source.map(value => value)
      )
    def timestamp: Optional[Iso8601Timestamp]
    def source: Optional[String]
    def getTimestamp: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getSource: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TerminationHealth
  ) extends zio.aws.chime.model.TerminationHealth.ReadOnly {
    override val timestamp: Optional[Iso8601Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val source: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TerminationHealth
  ): zio.aws.chime.model.TerminationHealth.ReadOnly = new Wrapper(impl)
}
