package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeContentIdentificationType {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType
}
object TranscribeContentIdentificationType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType
  ): zio.aws.chime.model.TranscribeContentIdentificationType = value match {
    case software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType.PII =>
      val r = PII
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType =
      software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PII
      extends zio.aws.chime.model.TranscribeContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType =
      software.amazon.awssdk.services.chime.model.TranscribeContentIdentificationType.PII
  }
}
