package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeContentRedactionType {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType
}
object TranscribeContentRedactionType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType
  ): zio.aws.chime.model.TranscribeContentRedactionType = value match {
    case software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType.PII =>
      val r = PII
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeContentRedactionType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType =
      software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType.UNKNOWN_TO_SDK_VERSION
  }
  case object PII extends zio.aws.chime.model.TranscribeContentRedactionType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType =
      software.amazon.awssdk.services.chime.model.TranscribeContentRedactionType.PII
  }
}
