package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeLanguageCode {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeLanguageCode
}
object TranscribeLanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeLanguageCode
  ): zio.aws.chime.model.TranscribeLanguageCode = value match {
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_US =>
      val r = `en-US`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_GB =>
      val r = `en-GB`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.ES_US =>
      val r = `es-US`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.FR_CA =>
      val r = `fr-CA`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.FR_FR =>
      val r = `fr-FR`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_AU =>
      val r = `en-AU`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.IT_IT =>
      val r = `it-IT`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.DE_DE =>
      val r = `de-DE`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.PT_BR =>
      val r = `pt-BR`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.JA_JP =>
      val r = `ja-JP`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.KO_KR =>
      val r = `ko-KR`
      r
    case software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.ZH_CN =>
      val r = `zh-CN`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_US
  }
  case object `en-GB` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_GB
  }
  case object `es-US` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.ES_US
  }
  case object `fr-CA` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.FR_CA
  }
  case object `fr-FR` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.FR_FR
  }
  case object `en-AU` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.EN_AU
  }
  case object `it-IT` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.IT_IT
  }
  case object `de-DE` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.DE_DE
  }
  case object `pt-BR` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.PT_BR
  }
  case object `ja-JP` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.JA_JP
  }
  case object `ko-KR` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.KO_KR
  }
  case object `zh-CN` extends zio.aws.chime.model.TranscribeLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeLanguageCode.ZH_CN
  }
}
