package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeMedicalContentIdentificationType {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType
}
object TranscribeMedicalContentIdentificationType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType
  ): zio.aws.chime.model.TranscribeMedicalContentIdentificationType =
    value match {
      case software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType.PHI =>
        val r = PHI
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeMedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType.UNKNOWN_TO_SDK_VERSION
  }
  case object PHI
      extends zio.aws.chime.model.TranscribeMedicalContentIdentificationType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalContentIdentificationType.PHI
  }
}
