package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeMedicalLanguageCode {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode
}
object TranscribeMedicalLanguageCode {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode
  ): zio.aws.chime.model.TranscribeMedicalLanguageCode = value match {
    case software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode.EN_US =>
      val r = `en-US`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeMedicalLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode.UNKNOWN_TO_SDK_VERSION
  }
  case object `en-US`
      extends zio.aws.chime.model.TranscribeMedicalLanguageCode {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalLanguageCode.EN_US
  }
}
