package zio.aws.chime.model
import scala.jdk.CollectionConverters._
sealed trait TranscribeMedicalType {
  def unwrap: software.amazon.awssdk.services.chime.model.TranscribeMedicalType
}
object TranscribeMedicalType {
  def wrap(
      value: software.amazon.awssdk.services.chime.model.TranscribeMedicalType
  ): zio.aws.chime.model.TranscribeMedicalType = value match {
    case software.amazon.awssdk.services.chime.model.TranscribeMedicalType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.chime.model.TranscribeMedicalType.CONVERSATION =>
      val r = CONVERSATION
      r
    case software.amazon.awssdk.services.chime.model.TranscribeMedicalType.DICTATION =>
      val r = DICTATION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.chime.model.TranscribeMedicalType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalType =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalType.UNKNOWN_TO_SDK_VERSION
  }
  case object CONVERSATION extends zio.aws.chime.model.TranscribeMedicalType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalType =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalType.CONVERSATION
  }
  case object DICTATION extends zio.aws.chime.model.TranscribeMedicalType {
    override def unwrap
        : software.amazon.awssdk.services.chime.model.TranscribeMedicalType =
      software.amazon.awssdk.services.chime.model.TranscribeMedicalType.DICTATION
  }
}
