package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TranscriptionConfiguration(
    engineTranscribeSettings: Optional[
      zio.aws.chime.model.EngineTranscribeSettings
    ] = Optional.Absent,
    engineTranscribeMedicalSettings: Optional[
      zio.aws.chime.model.EngineTranscribeMedicalSettings
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.TranscriptionConfiguration = {
    import TranscriptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.TranscriptionConfiguration
      .builder()
      .optionallyWith(
        engineTranscribeSettings.map(value => value.buildAwsValue())
      )(_.engineTranscribeSettings)
      .optionallyWith(
        engineTranscribeMedicalSettings.map(value => value.buildAwsValue())
      )(_.engineTranscribeMedicalSettings)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.TranscriptionConfiguration.ReadOnly =
    zio.aws.chime.model.TranscriptionConfiguration.wrap(buildAwsValue())
}
object TranscriptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.TranscriptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.TranscriptionConfiguration =
      zio.aws.chime.model.TranscriptionConfiguration(
        engineTranscribeSettings.map(value => value.asEditable),
        engineTranscribeMedicalSettings.map(value => value.asEditable)
      )
    def engineTranscribeSettings
        : Optional[zio.aws.chime.model.EngineTranscribeSettings.ReadOnly]
    def engineTranscribeMedicalSettings
        : Optional[zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly]
    def getEngineTranscribeSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.EngineTranscribeSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "engineTranscribeSettings",
      engineTranscribeSettings
    )
    def getEngineTranscribeMedicalSettings: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly
    ] = AwsError.unwrapOptionField(
      "engineTranscribeMedicalSettings",
      engineTranscribeMedicalSettings
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.TranscriptionConfiguration
  ) extends zio.aws.chime.model.TranscriptionConfiguration.ReadOnly {
    override val engineTranscribeSettings
        : Optional[zio.aws.chime.model.EngineTranscribeSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineTranscribeSettings())
        .map(value => zio.aws.chime.model.EngineTranscribeSettings.wrap(value))
    override val engineTranscribeMedicalSettings: Optional[
      zio.aws.chime.model.EngineTranscribeMedicalSettings.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.engineTranscribeMedicalSettings())
      .map(value =>
        zio.aws.chime.model.EngineTranscribeMedicalSettings.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.TranscriptionConfiguration
  ): zio.aws.chime.model.TranscriptionConfiguration.ReadOnly = new Wrapper(impl)
}
