package zio.aws.chime.model
import zio.aws.chime.model.primitives.{TagKey, GuidString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagAttendeeRequest(
    meetingId: GuidString,
    attendeeId: GuidString,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UntagAttendeeRequest = {
    import UntagAttendeeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UntagAttendeeRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .attendeeId(GuidString.unwrap(attendeeId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UntagAttendeeRequest.ReadOnly =
    zio.aws.chime.model.UntagAttendeeRequest.wrap(buildAwsValue())
}
object UntagAttendeeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UntagAttendeeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UntagAttendeeRequest =
      zio.aws.chime.model.UntagAttendeeRequest(meetingId, attendeeId, tagKeys)
    def meetingId: GuidString
    def attendeeId: GuidString
    def tagKeys: List[TagKey]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getAttendeeId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(attendeeId)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UntagAttendeeRequest
  ) extends zio.aws.chime.model.UntagAttendeeRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val attendeeId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.attendeeId())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UntagAttendeeRequest
  ): zio.aws.chime.model.UntagAttendeeRequest.ReadOnly = new Wrapper(impl)
}
