package zio.aws.chime.model
import zio.aws.chime.model.primitives.{TagKey, GuidString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagMeetingRequest(
    meetingId: GuidString,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UntagMeetingRequest = {
    import UntagMeetingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UntagMeetingRequest
      .builder()
      .meetingId(GuidString.unwrap(meetingId): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UntagMeetingRequest.ReadOnly =
    zio.aws.chime.model.UntagMeetingRequest.wrap(buildAwsValue())
}
object UntagMeetingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UntagMeetingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UntagMeetingRequest =
      zio.aws.chime.model.UntagMeetingRequest(meetingId, tagKeys)
    def meetingId: GuidString
    def tagKeys: List[TagKey]
    def getMeetingId: ZIO[Any, Nothing, GuidString] = ZIO.succeed(meetingId)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UntagMeetingRequest
  ) extends zio.aws.chime.model.UntagMeetingRequest.ReadOnly {
    override val meetingId: GuidString =
      zio.aws.chime.model.primitives.GuidString(impl.meetingId())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UntagMeetingRequest
  ): zio.aws.chime.model.UntagMeetingRequest.ReadOnly = new Wrapper(impl)
}
