package zio.aws.chime.model
import zio.aws.chime.model.primitives.{TagKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: Arn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UntagResourceRequest
      .builder()
      .resourceARN(Arn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UntagResourceRequest.ReadOnly =
    zio.aws.chime.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UntagResourceRequest =
      zio.aws.chime.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: Arn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UntagResourceRequest
  ) extends zio.aws.chime.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: Arn =
      zio.aws.chime.model.primitives.Arn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.chime.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UntagResourceRequest
  ): zio.aws.chime.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
