package zio.aws.chime.model
import zio.aws.chime.model.primitives.{AccountName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAccountRequest(
    accountId: NonEmptyString,
    name: Optional[AccountName] = Optional.Absent,
    defaultLicense: Optional[zio.aws.chime.model.License] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAccountRequest = {
    import UpdateAccountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAccountRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .optionallyWith(
        name.map(value => AccountName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(defaultLicense.map(value => value.unwrap))(
        _.defaultLicense
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAccountRequest.ReadOnly =
    zio.aws.chime.model.UpdateAccountRequest.wrap(buildAwsValue())
}
object UpdateAccountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAccountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAccountRequest =
      zio.aws.chime.model.UpdateAccountRequest(
        accountId,
        name.map(value => value),
        defaultLicense.map(value => value)
      )
    def accountId: NonEmptyString
    def name: Optional[AccountName]
    def defaultLicense: Optional[zio.aws.chime.model.License]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getName: ZIO[Any, AwsError, AccountName] =
      AwsError.unwrapOptionField("name", name)
    def getDefaultLicense: ZIO[Any, AwsError, zio.aws.chime.model.License] =
      AwsError.unwrapOptionField("defaultLicense", defaultLicense)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountRequest
  ) extends zio.aws.chime.model.UpdateAccountRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val name: Optional[AccountName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.AccountName(value))
    override val defaultLicense: Optional[zio.aws.chime.model.License] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultLicense())
        .map(value => zio.aws.chime.model.License.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountRequest
  ): zio.aws.chime.model.UpdateAccountRequest.ReadOnly = new Wrapper(impl)
}
