package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAccountResponse(
    account: Optional[zio.aws.chime.model.Account] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAccountResponse = {
    import UpdateAccountResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAccountResponse
      .builder()
      .optionallyWith(account.map(value => value.buildAwsValue()))(_.account)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAccountResponse.ReadOnly =
    zio.aws.chime.model.UpdateAccountResponse.wrap(buildAwsValue())
}
object UpdateAccountResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAccountResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAccountResponse =
      zio.aws.chime.model
        .UpdateAccountResponse(account.map(value => value.asEditable))
    def account: Optional[zio.aws.chime.model.Account.ReadOnly]
    def getAccount: ZIO[Any, AwsError, zio.aws.chime.model.Account.ReadOnly] =
      AwsError.unwrapOptionField("account", account)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountResponse
  ) extends zio.aws.chime.model.UpdateAccountResponse.ReadOnly {
    override val account: Optional[zio.aws.chime.model.Account.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.account())
        .map(value => zio.aws.chime.model.Account.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountResponse
  ): zio.aws.chime.model.UpdateAccountResponse.ReadOnly = new Wrapper(impl)
}
