package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateAccountSettingsRequest(
    accountId: NonEmptyString,
    accountSettings: zio.aws.chime.model.AccountSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest = {
    import UpdateAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .accountSettings(accountSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAccountSettingsRequest.ReadOnly =
    zio.aws.chime.model.UpdateAccountSettingsRequest.wrap(buildAwsValue())
}
object UpdateAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAccountSettingsRequest =
      zio.aws.chime.model
        .UpdateAccountSettingsRequest(accountId, accountSettings.asEditable)
    def accountId: NonEmptyString
    def accountSettings: zio.aws.chime.model.AccountSettings.ReadOnly
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getAccountSettings
        : ZIO[Any, Nothing, zio.aws.chime.model.AccountSettings.ReadOnly] =
      ZIO.succeed(accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest
  ) extends zio.aws.chime.model.UpdateAccountSettingsRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val accountSettings: zio.aws.chime.model.AccountSettings.ReadOnly =
      zio.aws.chime.model.AccountSettings.wrap(impl.accountSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAccountSettingsRequest
  ): zio.aws.chime.model.UpdateAccountSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
