package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, NonEmptyResourceName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppInstanceRequest(
    appInstanceArn: ChimeArn,
    name: NonEmptyResourceName,
    metadata: Optional[Metadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest = {
    import UpdateAppInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest
      .builder()
      .appInstanceArn(ChimeArn.unwrap(appInstanceArn): java.lang.String)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAppInstanceRequest.ReadOnly =
    zio.aws.chime.model.UpdateAppInstanceRequest.wrap(buildAwsValue())
}
object UpdateAppInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAppInstanceRequest =
      zio.aws.chime.model.UpdateAppInstanceRequest(
        appInstanceArn,
        name,
        metadata.map(value => value)
      )
    def appInstanceArn: ChimeArn
    def name: NonEmptyResourceName
    def metadata: Optional[Metadata]
    def getAppInstanceArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceArn)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest
  ) extends zio.aws.chime.model.UpdateAppInstanceRequest.ReadOnly {
    override val appInstanceArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceArn())
    override val name: NonEmptyResourceName =
      zio.aws.chime.model.primitives.NonEmptyResourceName(impl.name())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceRequest
  ): zio.aws.chime.model.UpdateAppInstanceRequest.ReadOnly = new Wrapper(impl)
}
