package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppInstanceResponse(
    appInstanceArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAppInstanceResponse = {
    import UpdateAppInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceResponse
      .builder()
      .optionallyWith(
        appInstanceArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.appInstanceArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly =
    zio.aws.chime.model.UpdateAppInstanceResponse.wrap(buildAwsValue())
}
object UpdateAppInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAppInstanceResponse =
      zio.aws.chime.model
        .UpdateAppInstanceResponse(appInstanceArn.map(value => value))
    def appInstanceArn: Optional[ChimeArn]
    def getAppInstanceArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceArn", appInstanceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceResponse
  ) extends zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly {
    override val appInstanceArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceResponse
  ): zio.aws.chime.model.UpdateAppInstanceResponse.ReadOnly = new Wrapper(impl)
}
