package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, UserName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppInstanceUserRequest(
    appInstanceUserArn: ChimeArn,
    name: UserName,
    metadata: Optional[Metadata] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest = {
    import UpdateAppInstanceUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest
      .builder()
      .appInstanceUserArn(ChimeArn.unwrap(appInstanceUserArn): java.lang.String)
      .name(UserName.unwrap(name): java.lang.String)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAppInstanceUserRequest.ReadOnly =
    zio.aws.chime.model.UpdateAppInstanceUserRequest.wrap(buildAwsValue())
}
object UpdateAppInstanceUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAppInstanceUserRequest =
      zio.aws.chime.model.UpdateAppInstanceUserRequest(
        appInstanceUserArn,
        name,
        metadata.map(value => value)
      )
    def appInstanceUserArn: ChimeArn
    def name: UserName
    def metadata: Optional[Metadata]
    def getAppInstanceUserArn: ZIO[Any, Nothing, ChimeArn] =
      ZIO.succeed(appInstanceUserArn)
    def getName: ZIO[Any, Nothing, UserName] = ZIO.succeed(name)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest
  ) extends zio.aws.chime.model.UpdateAppInstanceUserRequest.ReadOnly {
    override val appInstanceUserArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.appInstanceUserArn())
    override val name: UserName =
      zio.aws.chime.model.primitives.UserName(impl.name())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserRequest
  ): zio.aws.chime.model.UpdateAppInstanceUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
