package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAppInstanceUserResponse(
    appInstanceUserArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserResponse = {
    import UpdateAppInstanceUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserResponse
      .builder()
      .optionallyWith(
        appInstanceUserArn.map(value =>
          ChimeArn.unwrap(value): java.lang.String
        )
      )(_.appInstanceUserArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly =
    zio.aws.chime.model.UpdateAppInstanceUserResponse.wrap(buildAwsValue())
}
object UpdateAppInstanceUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateAppInstanceUserResponse =
      zio.aws.chime.model
        .UpdateAppInstanceUserResponse(appInstanceUserArn.map(value => value))
    def appInstanceUserArn: Optional[ChimeArn]
    def getAppInstanceUserArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("appInstanceUserArn", appInstanceUserArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserResponse
  ) extends zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly {
    override val appInstanceUserArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.appInstanceUserArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateAppInstanceUserResponse
  ): zio.aws.chime.model.UpdateAppInstanceUserResponse.ReadOnly = new Wrapper(
    impl
  )
}
