package zio.aws.chime.model
import zio.aws.chime.model.primitives.{NullableBoolean, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBotRequest(
    accountId: NonEmptyString,
    botId: NonEmptyString,
    disabled: Optional[NullableBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateBotRequest = {
    import UpdateBotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateBotRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .botId(NonEmptyString.unwrap(botId): java.lang.String)
      .optionallyWith(disabled.map(value => value: java.lang.Boolean))(
        _.disabled
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateBotRequest.ReadOnly =
    zio.aws.chime.model.UpdateBotRequest.wrap(buildAwsValue())
}
object UpdateBotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateBotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateBotRequest = zio.aws.chime.model
      .UpdateBotRequest(accountId, botId, disabled.map(value => value))
    def accountId: NonEmptyString
    def botId: NonEmptyString
    def disabled: Optional[NullableBoolean]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getBotId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(botId)
    def getDisabled: ZIO[Any, AwsError, NullableBoolean] =
      AwsError.unwrapOptionField("disabled", disabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateBotRequest
  ) extends zio.aws.chime.model.UpdateBotRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val botId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.botId())
    override val disabled: Optional[NullableBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => value: NullableBoolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateBotRequest
  ): zio.aws.chime.model.UpdateBotRequest.ReadOnly = new Wrapper(impl)
}
