package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBotResponse(
    bot: Optional[zio.aws.chime.model.Bot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateBotResponse = {
    import UpdateBotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateBotResponse
      .builder()
      .optionallyWith(bot.map(value => value.buildAwsValue()))(_.bot)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateBotResponse.ReadOnly =
    zio.aws.chime.model.UpdateBotResponse.wrap(buildAwsValue())
}
object UpdateBotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateBotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateBotResponse =
      zio.aws.chime.model.UpdateBotResponse(bot.map(value => value.asEditable))
    def bot: Optional[zio.aws.chime.model.Bot.ReadOnly]
    def getBot: ZIO[Any, AwsError, zio.aws.chime.model.Bot.ReadOnly] =
      AwsError.unwrapOptionField("bot", bot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateBotResponse
  ) extends zio.aws.chime.model.UpdateBotResponse.ReadOnly {
    override val bot: Optional[zio.aws.chime.model.Bot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bot())
        .map(value => zio.aws.chime.model.Bot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateBotResponse
  ): zio.aws.chime.model.UpdateBotResponse.ReadOnly = new Wrapper(impl)
}
