package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, Content, MessageId, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelMessageRequest(
    channelArn: ChimeArn,
    messageId: MessageId,
    content: Optional[Content] = Optional.Absent,
    metadata: Optional[Metadata] = Optional.Absent,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest = {
    import UpdateChannelMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .messageId(MessageId.unwrap(messageId): java.lang.String)
      .optionallyWith(
        content.map(value => Content.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateChannelMessageRequest.ReadOnly =
    zio.aws.chime.model.UpdateChannelMessageRequest.wrap(buildAwsValue())
}
object UpdateChannelMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateChannelMessageRequest =
      zio.aws.chime.model.UpdateChannelMessageRequest(
        channelArn,
        messageId,
        content.map(value => value),
        metadata.map(value => value),
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def messageId: MessageId
    def content: Optional[Content]
    def metadata: Optional[Metadata]
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getMessageId: ZIO[Any, Nothing, MessageId] = ZIO.succeed(messageId)
    def getContent: ZIO[Any, AwsError, Content] =
      AwsError.unwrapOptionField("content", content)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest
  ) extends zio.aws.chime.model.UpdateChannelMessageRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val messageId: MessageId =
      zio.aws.chime.model.primitives.MessageId(impl.messageId())
    override val content: Optional[Content] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.chime.model.primitives.Content(value))
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelMessageRequest
  ): zio.aws.chime.model.UpdateChannelMessageRequest.ReadOnly = new Wrapper(
    impl
  )
}
