package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelReadMarkerRequest(
    channelArn: ChimeArn,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest = {
    import UpdateChannelReadMarkerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateChannelReadMarkerRequest.ReadOnly =
    zio.aws.chime.model.UpdateChannelReadMarkerRequest.wrap(buildAwsValue())
}
object UpdateChannelReadMarkerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateChannelReadMarkerRequest =
      zio.aws.chime.model.UpdateChannelReadMarkerRequest(
        channelArn,
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest
  ) extends zio.aws.chime.model.UpdateChannelReadMarkerRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerRequest
  ): zio.aws.chime.model.UpdateChannelReadMarkerRequest.ReadOnly = new Wrapper(
    impl
  )
}
