package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelReadMarkerResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerResponse = {
    import UpdateChannelReadMarkerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly =
    zio.aws.chime.model.UpdateChannelReadMarkerResponse.wrap(buildAwsValue())
}
object UpdateChannelReadMarkerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateChannelReadMarkerResponse =
      zio.aws.chime.model
        .UpdateChannelReadMarkerResponse(channelArn.map(value => value))
    def channelArn: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerResponse
  ) extends zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelReadMarkerResponse
  ): zio.aws.chime.model.UpdateChannelReadMarkerResponse.ReadOnly = new Wrapper(
    impl
  )
}
