package zio.aws.chime.model
import zio.aws.chime.model.primitives.{Metadata, NonEmptyResourceName, ChimeArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    channelArn: ChimeArn,
    name: NonEmptyResourceName,
    mode: zio.aws.chime.model.ChannelMode,
    metadata: Optional[Metadata] = Optional.Absent,
    chimeBearer: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateChannelRequest
      .builder()
      .channelArn(ChimeArn.unwrap(channelArn): java.lang.String)
      .name(NonEmptyResourceName.unwrap(name): java.lang.String)
      .mode(mode.unwrap)
      .optionallyWith(
        metadata.map(value => Metadata.unwrap(value): java.lang.String)
      )(_.metadata)
      .optionallyWith(
        chimeBearer.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.chimeBearer)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateChannelRequest.ReadOnly =
    zio.aws.chime.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateChannelRequest =
      zio.aws.chime.model.UpdateChannelRequest(
        channelArn,
        name,
        mode,
        metadata.map(value => value),
        chimeBearer.map(value => value)
      )
    def channelArn: ChimeArn
    def name: NonEmptyResourceName
    def mode: zio.aws.chime.model.ChannelMode
    def metadata: Optional[Metadata]
    def chimeBearer: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, Nothing, ChimeArn] = ZIO.succeed(channelArn)
    def getName: ZIO[Any, Nothing, NonEmptyResourceName] = ZIO.succeed(name)
    def getMode: ZIO[Any, Nothing, zio.aws.chime.model.ChannelMode] =
      ZIO.succeed(mode)
    def getMetadata: ZIO[Any, AwsError, Metadata] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getChimeBearer: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("chimeBearer", chimeBearer)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelRequest
  ) extends zio.aws.chime.model.UpdateChannelRequest.ReadOnly {
    override val channelArn: ChimeArn =
      zio.aws.chime.model.primitives.ChimeArn(impl.channelArn())
    override val name: NonEmptyResourceName =
      zio.aws.chime.model.primitives.NonEmptyResourceName(impl.name())
    override val mode: zio.aws.chime.model.ChannelMode =
      zio.aws.chime.model.ChannelMode.wrap(impl.mode())
    override val metadata: Optional[Metadata] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.chime.model.primitives.Metadata(value))
    override val chimeBearer: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.chimeBearer())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelRequest
  ): zio.aws.chime.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
