package zio.aws.chime.model
import zio.aws.chime.model.primitives.ChimeArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelResponse(
    channelArn: Optional[ChimeArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateChannelResponse = {
    import UpdateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateChannelResponse
      .builder()
      .optionallyWith(
        channelArn.map(value => ChimeArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateChannelResponse.ReadOnly =
    zio.aws.chime.model.UpdateChannelResponse.wrap(buildAwsValue())
}
object UpdateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateChannelResponse =
      zio.aws.chime.model.UpdateChannelResponse(channelArn.map(value => value))
    def channelArn: Optional[ChimeArn]
    def getChannelArn: ZIO[Any, AwsError, ChimeArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelResponse
  ) extends zio.aws.chime.model.UpdateChannelResponse.ReadOnly {
    override val channelArn: Optional[ChimeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.chime.model.primitives.ChimeArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateChannelResponse
  ): zio.aws.chime.model.UpdateChannelResponse.ReadOnly = new Wrapper(impl)
}
