package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateGlobalSettingsRequest(
    businessCalling: Optional[zio.aws.chime.model.BusinessCallingSettings] =
      Optional.Absent,
    voiceConnector: Optional[zio.aws.chime.model.VoiceConnectorSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest = {
    import UpdateGlobalSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest
      .builder()
      .optionallyWith(businessCalling.map(value => value.buildAwsValue()))(
        _.businessCalling
      )
      .optionallyWith(voiceConnector.map(value => value.buildAwsValue()))(
        _.voiceConnector
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateGlobalSettingsRequest.ReadOnly =
    zio.aws.chime.model.UpdateGlobalSettingsRequest.wrap(buildAwsValue())
}
object UpdateGlobalSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateGlobalSettingsRequest =
      zio.aws.chime.model.UpdateGlobalSettingsRequest(
        businessCalling.map(value => value.asEditable),
        voiceConnector.map(value => value.asEditable)
      )
    def businessCalling
        : Optional[zio.aws.chime.model.BusinessCallingSettings.ReadOnly]
    def voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnectorSettings.ReadOnly]
    def getBusinessCalling: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.BusinessCallingSettings.ReadOnly
    ] = AwsError.unwrapOptionField("businessCalling", businessCalling)
    def getVoiceConnector: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.VoiceConnectorSettings.ReadOnly
    ] = AwsError.unwrapOptionField("voiceConnector", voiceConnector)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest
  ) extends zio.aws.chime.model.UpdateGlobalSettingsRequest.ReadOnly {
    override val businessCalling
        : Optional[zio.aws.chime.model.BusinessCallingSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.businessCalling())
        .map(value => zio.aws.chime.model.BusinessCallingSettings.wrap(value))
    override val voiceConnector
        : Optional[zio.aws.chime.model.VoiceConnectorSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnector())
        .map(value => zio.aws.chime.model.VoiceConnectorSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateGlobalSettingsRequest
  ): zio.aws.chime.model.UpdateGlobalSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
