package zio.aws.chime.model
import zio.aws.chime.model.primitives.CallingName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberRequest(
    phoneNumberId: String,
    productType: Optional[zio.aws.chime.model.PhoneNumberProductType] =
      Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest = {
    import UpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest
      .builder()
      .phoneNumberId(phoneNumberId: java.lang.String)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdatePhoneNumberRequest.ReadOnly =
    zio.aws.chime.model.UpdatePhoneNumberRequest.wrap(buildAwsValue())
}
object UpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdatePhoneNumberRequest =
      zio.aws.chime.model.UpdatePhoneNumberRequest(
        phoneNumberId,
        productType.map(value => value),
        callingName.map(value => value)
      )
    def phoneNumberId: String
    def productType: Optional[zio.aws.chime.model.PhoneNumberProductType]
    def callingName: Optional[CallingName]
    def getPhoneNumberId: ZIO[Any, Nothing, String] = ZIO.succeed(phoneNumberId)
    def getProductType
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberProductType] =
      AwsError.unwrapOptionField("productType", productType)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest
  ) extends zio.aws.chime.model.UpdatePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: String = impl.phoneNumberId(): String
    override val productType
        : Optional[zio.aws.chime.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value => zio.aws.chime.model.PhoneNumberProductType.wrap(value))
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chime.model.primitives.CallingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequest
  ): zio.aws.chime.model.UpdatePhoneNumberRequest.ReadOnly = new Wrapper(impl)
}
