package zio.aws.chime.model
import zio.aws.chime.model.primitives.{CallingName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberRequestItem(
    phoneNumberId: NonEmptyString,
    productType: Optional[zio.aws.chime.model.PhoneNumberProductType] =
      Optional.Absent,
    callingName: Optional[CallingName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequestItem = {
    import UpdatePhoneNumberRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequestItem
      .builder()
      .phoneNumberId(NonEmptyString.unwrap(phoneNumberId): java.lang.String)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(
        callingName.map(value => CallingName.unwrap(value): java.lang.String)
      )(_.callingName)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly =
    zio.aws.chime.model.UpdatePhoneNumberRequestItem.wrap(buildAwsValue())
}
object UpdatePhoneNumberRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdatePhoneNumberRequestItem =
      zio.aws.chime.model.UpdatePhoneNumberRequestItem(
        phoneNumberId,
        productType.map(value => value),
        callingName.map(value => value)
      )
    def phoneNumberId: NonEmptyString
    def productType: Optional[zio.aws.chime.model.PhoneNumberProductType]
    def callingName: Optional[CallingName]
    def getPhoneNumberId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(phoneNumberId)
    def getProductType
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumberProductType] =
      AwsError.unwrapOptionField("productType", productType)
    def getCallingName: ZIO[Any, AwsError, CallingName] =
      AwsError.unwrapOptionField("callingName", callingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequestItem
  ) extends zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly {
    override val phoneNumberId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.phoneNumberId())
    override val productType
        : Optional[zio.aws.chime.model.PhoneNumberProductType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productType())
        .map(value => zio.aws.chime.model.PhoneNumberProductType.wrap(value))
    override val callingName: Optional[CallingName] = zio.aws.core.internal
      .optionalFromNullable(impl.callingName())
      .map(value => zio.aws.chime.model.primitives.CallingName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberRequestItem
  ): zio.aws.chime.model.UpdatePhoneNumberRequestItem.ReadOnly = new Wrapper(
    impl
  )
}
