package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberResponse(
    phoneNumber: Optional[zio.aws.chime.model.PhoneNumber] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse = {
    import UpdatePhoneNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse
      .builder()
      .optionallyWith(phoneNumber.map(value => value.buildAwsValue()))(
        _.phoneNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly =
    zio.aws.chime.model.UpdatePhoneNumberResponse.wrap(buildAwsValue())
}
object UpdatePhoneNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdatePhoneNumberResponse =
      zio.aws.chime.model
        .UpdatePhoneNumberResponse(phoneNumber.map(value => value.asEditable))
    def phoneNumber: Optional[zio.aws.chime.model.PhoneNumber.ReadOnly]
    def getPhoneNumber
        : ZIO[Any, AwsError, zio.aws.chime.model.PhoneNumber.ReadOnly] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse
  ) extends zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly {
    override val phoneNumber
        : Optional[zio.aws.chime.model.PhoneNumber.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumber())
        .map(value => zio.aws.chime.model.PhoneNumber.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberResponse
  ): zio.aws.chime.model.UpdatePhoneNumberResponse.ReadOnly = new Wrapper(impl)
}
