package zio.aws.chime.model
import zio.aws.chime.model.primitives.CallingName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdatePhoneNumberSettingsRequest(callingName: CallingName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest = {
    import UpdatePhoneNumberSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest
      .builder()
      .callingName(CallingName.unwrap(callingName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdatePhoneNumberSettingsRequest.ReadOnly =
    zio.aws.chime.model.UpdatePhoneNumberSettingsRequest.wrap(buildAwsValue())
}
object UpdatePhoneNumberSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdatePhoneNumberSettingsRequest =
      zio.aws.chime.model.UpdatePhoneNumberSettingsRequest(callingName)
    def callingName: CallingName
    def getCallingName: ZIO[Any, Nothing, CallingName] =
      ZIO.succeed(callingName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest
  ) extends zio.aws.chime.model.UpdatePhoneNumberSettingsRequest.ReadOnly {
    override val callingName: CallingName =
      zio.aws.chime.model.primitives.CallingName(impl.callingName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdatePhoneNumberSettingsRequest
  ): zio.aws.chime.model.UpdatePhoneNumberSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
