package zio.aws.chime.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{PositiveInteger, NonEmptyString128}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateProxySessionRequest(
    voiceConnectorId: NonEmptyString128,
    proxySessionId: NonEmptyString128,
    capabilities: Iterable[zio.aws.chime.model.Capability],
    expiryMinutes: Optional[PositiveInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest = {
    import UpdateProxySessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString128.unwrap(voiceConnectorId): java.lang.String
      )
      .proxySessionId(
        NonEmptyString128.unwrap(proxySessionId): java.lang.String
      )
      .capabilitiesWithStrings(capabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        expiryMinutes.map(value => PositiveInteger.unwrap(value): Integer)
      )(_.expiryMinutes)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateProxySessionRequest.ReadOnly =
    zio.aws.chime.model.UpdateProxySessionRequest.wrap(buildAwsValue())
}
object UpdateProxySessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateProxySessionRequest =
      zio.aws.chime.model.UpdateProxySessionRequest(
        voiceConnectorId,
        proxySessionId,
        capabilities,
        expiryMinutes.map(value => value)
      )
    def voiceConnectorId: NonEmptyString128
    def proxySessionId: NonEmptyString128
    def capabilities: List[zio.aws.chime.model.Capability]
    def expiryMinutes: Optional[PositiveInteger]
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(voiceConnectorId)
    def getProxySessionId: ZIO[Any, Nothing, NonEmptyString128] =
      ZIO.succeed(proxySessionId)
    def getCapabilities
        : ZIO[Any, Nothing, List[zio.aws.chime.model.Capability]] =
      ZIO.succeed(capabilities)
    def getExpiryMinutes: ZIO[Any, AwsError, PositiveInteger] =
      AwsError.unwrapOptionField("expiryMinutes", expiryMinutes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest
  ) extends zio.aws.chime.model.UpdateProxySessionRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.voiceConnectorId())
    override val proxySessionId: NonEmptyString128 =
      zio.aws.chime.model.primitives.NonEmptyString128(impl.proxySessionId())
    override val capabilities: List[zio.aws.chime.model.Capability] = impl
      .capabilities()
      .asScala
      .map { item =>
        zio.aws.chime.model.Capability.wrap(item)
      }
      .toList
    override val expiryMinutes: Optional[PositiveInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.expiryMinutes())
        .map(value => zio.aws.chime.model.primitives.PositiveInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateProxySessionRequest
  ): zio.aws.chime.model.UpdateProxySessionRequest.ReadOnly = new Wrapper(impl)
}
