package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProxySessionResponse(
    proxySession: Optional[zio.aws.chime.model.ProxySession] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse = {
    import UpdateProxySessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse
      .builder()
      .optionallyWith(proxySession.map(value => value.buildAwsValue()))(
        _.proxySession
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly =
    zio.aws.chime.model.UpdateProxySessionResponse.wrap(buildAwsValue())
}
object UpdateProxySessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateProxySessionResponse =
      zio.aws.chime.model
        .UpdateProxySessionResponse(proxySession.map(value => value.asEditable))
    def proxySession: Optional[zio.aws.chime.model.ProxySession.ReadOnly]
    def getProxySession
        : ZIO[Any, AwsError, zio.aws.chime.model.ProxySession.ReadOnly] =
      AwsError.unwrapOptionField("proxySession", proxySession)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse
  ) extends zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly {
    override val proxySession
        : Optional[zio.aws.chime.model.ProxySession.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.proxySession())
        .map(value => zio.aws.chime.model.ProxySession.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateProxySessionResponse
  ): zio.aws.chime.model.UpdateProxySessionResponse.ReadOnly = new Wrapper(impl)
}
