package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SensitiveString, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRoomRequest(
    accountId: NonEmptyString,
    roomId: NonEmptyString,
    name: Optional[SensitiveString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateRoomRequest = {
    import UpdateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateRoomRequest
      .builder()
      .accountId(NonEmptyString.unwrap(accountId): java.lang.String)
      .roomId(NonEmptyString.unwrap(roomId): java.lang.String)
      .optionallyWith(
        name.map(value => SensitiveString.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateRoomRequest.ReadOnly =
    zio.aws.chime.model.UpdateRoomRequest.wrap(buildAwsValue())
}
object UpdateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateRoomRequest = zio.aws.chime.model
      .UpdateRoomRequest(accountId, roomId, name.map(value => value))
    def accountId: NonEmptyString
    def roomId: NonEmptyString
    def name: Optional[SensitiveString]
    def getAccountId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(accountId)
    def getRoomId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(roomId)
    def getName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateRoomRequest
  ) extends zio.aws.chime.model.UpdateRoomRequest.ReadOnly {
    override val accountId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.accountId())
    override val roomId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.roomId())
    override val name: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateRoomRequest
  ): zio.aws.chime.model.UpdateRoomRequest.ReadOnly = new Wrapper(impl)
}
