package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateRoomResponse(
    room: Optional[zio.aws.chime.model.Room] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateRoomResponse = {
    import UpdateRoomResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateRoomResponse
      .builder()
      .optionallyWith(room.map(value => value.buildAwsValue()))(_.room)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateRoomResponse.ReadOnly =
    zio.aws.chime.model.UpdateRoomResponse.wrap(buildAwsValue())
}
object UpdateRoomResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateRoomResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateRoomResponse = zio.aws.chime.model
      .UpdateRoomResponse(room.map(value => value.asEditable))
    def room: Optional[zio.aws.chime.model.Room.ReadOnly]
    def getRoom: ZIO[Any, AwsError, zio.aws.chime.model.Room.ReadOnly] =
      AwsError.unwrapOptionField("room", room)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateRoomResponse
  ) extends zio.aws.chime.model.UpdateRoomResponse.ReadOnly {
    override val room: Optional[zio.aws.chime.model.Room.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.room())
        .map(value => zio.aws.chime.model.Room.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateRoomResponse
  ): zio.aws.chime.model.UpdateRoomResponse.ReadOnly = new Wrapper(impl)
}
