package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SensitiveString, NonEmptyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateSipMediaApplicationCallRequest(
    sipMediaApplicationId: NonEmptyString,
    transactionId: NonEmptyString,
    arguments: Map[SensitiveString, SensitiveString]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest = {
    import UpdateSipMediaApplicationCallRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .transactionId(NonEmptyString.unwrap(transactionId): java.lang.String)
      .arguments(
        arguments
          .map({ case (key, value) =>
            (SensitiveString.unwrap(key): java.lang.String) -> (SensitiveString
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateSipMediaApplicationCallRequest.ReadOnly =
    zio.aws.chime.model.UpdateSipMediaApplicationCallRequest
      .wrap(buildAwsValue())
}
object UpdateSipMediaApplicationCallRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateSipMediaApplicationCallRequest =
      zio.aws.chime.model.UpdateSipMediaApplicationCallRequest(
        sipMediaApplicationId,
        transactionId,
        arguments
      )
    def sipMediaApplicationId: NonEmptyString
    def transactionId: NonEmptyString
    def arguments: Map[SensitiveString, SensitiveString]
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
    def getTransactionId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(transactionId)
    def getArguments: ZIO[Any, Nothing, Map[SensitiveString, SensitiveString]] =
      ZIO.succeed(arguments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest
  ) extends zio.aws.chime.model.UpdateSipMediaApplicationCallRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
    override val transactionId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.transactionId())
    override val arguments: Map[SensitiveString, SensitiveString] = impl
      .arguments()
      .asScala
      .map({ case (key, value) =>
        zio.aws.chime.model.primitives.SensitiveString(
          key
        ) -> zio.aws.chime.model.primitives.SensitiveString(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallRequest
  ): zio.aws.chime.model.UpdateSipMediaApplicationCallRequest.ReadOnly =
    new Wrapper(impl)
}
