package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSipMediaApplicationCallResponse(
    sipMediaApplicationCall: Optional[
      zio.aws.chime.model.SipMediaApplicationCall
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallResponse = {
    import UpdateSipMediaApplicationCallResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallResponse
      .builder()
      .optionallyWith(
        sipMediaApplicationCall.map(value => value.buildAwsValue())
      )(_.sipMediaApplicationCall)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly =
    zio.aws.chime.model.UpdateSipMediaApplicationCallResponse
      .wrap(buildAwsValue())
}
object UpdateSipMediaApplicationCallResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateSipMediaApplicationCallResponse =
      zio.aws.chime.model.UpdateSipMediaApplicationCallResponse(
        sipMediaApplicationCall.map(value => value.asEditable)
      )
    def sipMediaApplicationCall
        : Optional[zio.aws.chime.model.SipMediaApplicationCall.ReadOnly]
    def getSipMediaApplicationCall: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.SipMediaApplicationCall.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sipMediaApplicationCall",
      sipMediaApplicationCall
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallResponse
  ) extends zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly {
    override val sipMediaApplicationCall
        : Optional[zio.aws.chime.model.SipMediaApplicationCall.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplicationCall())
        .map(value => zio.aws.chime.model.SipMediaApplicationCall.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationCallResponse
  ): zio.aws.chime.model.UpdateSipMediaApplicationCallResponse.ReadOnly =
    new Wrapper(impl)
}
