package zio.aws.chime.model
import zio.aws.chime.model.primitives.{SipMediaApplicationName, NonEmptyString}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSipMediaApplicationRequest(
    sipMediaApplicationId: NonEmptyString,
    name: Optional[SipMediaApplicationName] = Optional.Absent,
    endpoints: Optional[
      Iterable[zio.aws.chime.model.SipMediaApplicationEndpoint]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest = {
    import UpdateSipMediaApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest
      .builder()
      .sipMediaApplicationId(
        NonEmptyString.unwrap(sipMediaApplicationId): java.lang.String
      )
      .optionallyWith(
        name.map(value =>
          SipMediaApplicationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateSipMediaApplicationRequest.ReadOnly =
    zio.aws.chime.model.UpdateSipMediaApplicationRequest.wrap(buildAwsValue())
}
object UpdateSipMediaApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateSipMediaApplicationRequest =
      zio.aws.chime.model.UpdateSipMediaApplicationRequest(
        sipMediaApplicationId,
        name.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sipMediaApplicationId: NonEmptyString
    def name: Optional[SipMediaApplicationName]
    def endpoints: Optional[
      List[zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly]
    ]
    def getSipMediaApplicationId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(sipMediaApplicationId)
    def getName: ZIO[Any, AwsError, SipMediaApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest
  ) extends zio.aws.chime.model.UpdateSipMediaApplicationRequest.ReadOnly {
    override val sipMediaApplicationId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.sipMediaApplicationId())
    override val name: Optional[SipMediaApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.chime.model.primitives.SipMediaApplicationName(value)
      )
    override val endpoints: Optional[
      List[zio.aws.chime.model.SipMediaApplicationEndpoint.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.chime.model.SipMediaApplicationEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationRequest
  ): zio.aws.chime.model.UpdateSipMediaApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
