package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSipMediaApplicationResponse(
    sipMediaApplication: Optional[zio.aws.chime.model.SipMediaApplication] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationResponse = {
    import UpdateSipMediaApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationResponse
      .builder()
      .optionallyWith(sipMediaApplication.map(value => value.buildAwsValue()))(
        _.sipMediaApplication
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly =
    zio.aws.chime.model.UpdateSipMediaApplicationResponse.wrap(buildAwsValue())
}
object UpdateSipMediaApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateSipMediaApplicationResponse =
      zio.aws.chime.model.UpdateSipMediaApplicationResponse(
        sipMediaApplication.map(value => value.asEditable)
      )
    def sipMediaApplication
        : Optional[zio.aws.chime.model.SipMediaApplication.ReadOnly]
    def getSipMediaApplication
        : ZIO[Any, AwsError, zio.aws.chime.model.SipMediaApplication.ReadOnly] =
      AwsError.unwrapOptionField("sipMediaApplication", sipMediaApplication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationResponse
  ) extends zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly {
    override val sipMediaApplication
        : Optional[zio.aws.chime.model.SipMediaApplication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipMediaApplication())
        .map(value => zio.aws.chime.model.SipMediaApplication.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipMediaApplicationResponse
  ): zio.aws.chime.model.UpdateSipMediaApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
