package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSipRuleResponse(
    sipRule: Optional[zio.aws.chime.model.SipRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateSipRuleResponse = {
    import UpdateSipRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateSipRuleResponse
      .builder()
      .optionallyWith(sipRule.map(value => value.buildAwsValue()))(_.sipRule)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly =
    zio.aws.chime.model.UpdateSipRuleResponse.wrap(buildAwsValue())
}
object UpdateSipRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateSipRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateSipRuleResponse =
      zio.aws.chime.model
        .UpdateSipRuleResponse(sipRule.map(value => value.asEditable))
    def sipRule: Optional[zio.aws.chime.model.SipRule.ReadOnly]
    def getSipRule: ZIO[Any, AwsError, zio.aws.chime.model.SipRule.ReadOnly] =
      AwsError.unwrapOptionField("sipRule", sipRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipRuleResponse
  ) extends zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly {
    override val sipRule: Optional[zio.aws.chime.model.SipRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sipRule())
        .map(value => zio.aws.chime.model.SipRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateSipRuleResponse
  ): zio.aws.chime.model.UpdateSipRuleResponse.ReadOnly = new Wrapper(impl)
}
