package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateUserRequestItem(
    userId: NonEmptyString,
    licenseType: Optional[zio.aws.chime.model.License] = Optional.Absent,
    userType: Optional[zio.aws.chime.model.UserType] = Optional.Absent,
    alexaForBusinessMetadata: Optional[
      zio.aws.chime.model.AlexaForBusinessMetadata
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateUserRequestItem = {
    import UpdateUserRequestItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateUserRequestItem
      .builder()
      .userId(NonEmptyString.unwrap(userId): java.lang.String)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .optionallyWith(
        alexaForBusinessMetadata.map(value => value.buildAwsValue())
      )(_.alexaForBusinessMetadata)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateUserRequestItem.ReadOnly =
    zio.aws.chime.model.UpdateUserRequestItem.wrap(buildAwsValue())
}
object UpdateUserRequestItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateUserRequestItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateUserRequestItem =
      zio.aws.chime.model.UpdateUserRequestItem(
        userId,
        licenseType.map(value => value),
        userType.map(value => value),
        alexaForBusinessMetadata.map(value => value.asEditable)
      )
    def userId: NonEmptyString
    def licenseType: Optional[zio.aws.chime.model.License]
    def userType: Optional[zio.aws.chime.model.UserType]
    def alexaForBusinessMetadata
        : Optional[zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly]
    def getUserId: ZIO[Any, Nothing, NonEmptyString] = ZIO.succeed(userId)
    def getLicenseType: ZIO[Any, AwsError, zio.aws.chime.model.License] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getUserType: ZIO[Any, AwsError, zio.aws.chime.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
    def getAlexaForBusinessMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "alexaForBusinessMetadata",
      alexaForBusinessMetadata
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateUserRequestItem
  ) extends zio.aws.chime.model.UpdateUserRequestItem.ReadOnly {
    override val userId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.userId())
    override val licenseType: Optional[zio.aws.chime.model.License] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.chime.model.License.wrap(value))
    override val userType: Optional[zio.aws.chime.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.chime.model.UserType.wrap(value))
    override val alexaForBusinessMetadata
        : Optional[zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alexaForBusinessMetadata())
        .map(value => zio.aws.chime.model.AlexaForBusinessMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateUserRequestItem
  ): zio.aws.chime.model.UpdateUserRequestItem.ReadOnly = new Wrapper(impl)
}
