package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateUserSettingsRequest(
    accountId: String,
    userId: String,
    userSettings: zio.aws.chime.model.UserSettings
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest = {
    import UpdateUserSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest
      .builder()
      .accountId(accountId: java.lang.String)
      .userId(userId: java.lang.String)
      .userSettings(userSettings.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateUserSettingsRequest.ReadOnly =
    zio.aws.chime.model.UpdateUserSettingsRequest.wrap(buildAwsValue())
}
object UpdateUserSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateUserSettingsRequest =
      zio.aws.chime.model
        .UpdateUserSettingsRequest(accountId, userId, userSettings.asEditable)
    def accountId: String
    def userId: String
    def userSettings: zio.aws.chime.model.UserSettings.ReadOnly
    def getAccountId: ZIO[Any, Nothing, String] = ZIO.succeed(accountId)
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
    def getUserSettings
        : ZIO[Any, Nothing, zio.aws.chime.model.UserSettings.ReadOnly] =
      ZIO.succeed(userSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest
  ) extends zio.aws.chime.model.UpdateUserSettingsRequest.ReadOnly {
    override val accountId: String = impl.accountId(): String
    override val userId: String = impl.userId(): String
    override val userSettings: zio.aws.chime.model.UserSettings.ReadOnly =
      zio.aws.chime.model.UserSettings.wrap(impl.userSettings())
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateUserSettingsRequest
  ): zio.aws.chime.model.UpdateUserSettingsRequest.ReadOnly = new Wrapper(impl)
}
