package zio.aws.chime.model
import zio.aws.chime.model.primitives.{VoiceConnectorGroupName, NonEmptyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorGroupRequest(
    voiceConnectorGroupId: NonEmptyString,
    name: VoiceConnectorGroupName,
    voiceConnectorItems: Iterable[zio.aws.chime.model.VoiceConnectorItem]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest = {
    import UpdateVoiceConnectorGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest
      .builder()
      .voiceConnectorGroupId(
        NonEmptyString.unwrap(voiceConnectorGroupId): java.lang.String
      )
      .name(VoiceConnectorGroupName.unwrap(name): java.lang.String)
      .voiceConnectorItems(voiceConnectorItems.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateVoiceConnectorGroupRequest.ReadOnly =
    zio.aws.chime.model.UpdateVoiceConnectorGroupRequest.wrap(buildAwsValue())
}
object UpdateVoiceConnectorGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateVoiceConnectorGroupRequest =
      zio.aws.chime.model.UpdateVoiceConnectorGroupRequest(
        voiceConnectorGroupId,
        name,
        voiceConnectorItems.map { item =>
          item.asEditable
        }
      )
    def voiceConnectorGroupId: NonEmptyString
    def name: VoiceConnectorGroupName
    def voiceConnectorItems
        : List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly]
    def getVoiceConnectorGroupId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorGroupId)
    def getName: ZIO[Any, Nothing, VoiceConnectorGroupName] = ZIO.succeed(name)
    def getVoiceConnectorItems: ZIO[Any, Nothing, List[
      zio.aws.chime.model.VoiceConnectorItem.ReadOnly
    ]] = ZIO.succeed(voiceConnectorItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest
  ) extends zio.aws.chime.model.UpdateVoiceConnectorGroupRequest.ReadOnly {
    override val voiceConnectorGroupId: NonEmptyString =
      zio.aws.chime.model.primitives
        .NonEmptyString(impl.voiceConnectorGroupId())
    override val name: VoiceConnectorGroupName =
      zio.aws.chime.model.primitives.VoiceConnectorGroupName(impl.name())
    override val voiceConnectorItems
        : List[zio.aws.chime.model.VoiceConnectorItem.ReadOnly] = impl
      .voiceConnectorItems()
      .asScala
      .map { item =>
        zio.aws.chime.model.VoiceConnectorItem.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupRequest
  ): zio.aws.chime.model.UpdateVoiceConnectorGroupRequest.ReadOnly =
    new Wrapper(impl)
}
