package zio.aws.chime.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorGroupResponse(
    voiceConnectorGroup: Optional[zio.aws.chime.model.VoiceConnectorGroup] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse = {
    import UpdateVoiceConnectorGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse
      .builder()
      .optionallyWith(voiceConnectorGroup.map(value => value.buildAwsValue()))(
        _.voiceConnectorGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly =
    zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.wrap(buildAwsValue())
}
object UpdateVoiceConnectorGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateVoiceConnectorGroupResponse =
      zio.aws.chime.model.UpdateVoiceConnectorGroupResponse(
        voiceConnectorGroup.map(value => value.asEditable)
      )
    def voiceConnectorGroup
        : Optional[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly]
    def getVoiceConnectorGroup
        : ZIO[Any, AwsError, zio.aws.chime.model.VoiceConnectorGroup.ReadOnly] =
      AwsError.unwrapOptionField("voiceConnectorGroup", voiceConnectorGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse
  ) extends zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly {
    override val voiceConnectorGroup
        : Optional[zio.aws.chime.model.VoiceConnectorGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceConnectorGroup())
        .map(value => zio.aws.chime.model.VoiceConnectorGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorGroupResponse
  ): zio.aws.chime.model.UpdateVoiceConnectorGroupResponse.ReadOnly =
    new Wrapper(impl)
}
