package zio.aws.chime.model
import zio.aws.chime.model.primitives.{VoiceConnectorName, NonEmptyString}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVoiceConnectorRequest(
    voiceConnectorId: NonEmptyString,
    name: VoiceConnectorName,
    requireEncryption: Boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest = {
    import UpdateVoiceConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest
      .builder()
      .voiceConnectorId(
        NonEmptyString.unwrap(voiceConnectorId): java.lang.String
      )
      .name(VoiceConnectorName.unwrap(name): java.lang.String)
      .requireEncryption(requireEncryption: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UpdateVoiceConnectorRequest.ReadOnly =
    zio.aws.chime.model.UpdateVoiceConnectorRequest.wrap(buildAwsValue())
}
object UpdateVoiceConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UpdateVoiceConnectorRequest =
      zio.aws.chime.model
        .UpdateVoiceConnectorRequest(voiceConnectorId, name, requireEncryption)
    def voiceConnectorId: NonEmptyString
    def name: VoiceConnectorName
    def requireEncryption: Boolean
    def getVoiceConnectorId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(voiceConnectorId)
    def getName: ZIO[Any, Nothing, VoiceConnectorName] = ZIO.succeed(name)
    def getRequireEncryption: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(requireEncryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest
  ) extends zio.aws.chime.model.UpdateVoiceConnectorRequest.ReadOnly {
    override val voiceConnectorId: NonEmptyString =
      zio.aws.chime.model.primitives.NonEmptyString(impl.voiceConnectorId())
    override val name: VoiceConnectorName =
      zio.aws.chime.model.primitives.VoiceConnectorName(impl.name())
    override val requireEncryption: Boolean = impl.requireEncryption(): Boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UpdateVoiceConnectorRequest
  ): zio.aws.chime.model.UpdateVoiceConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
