package zio.aws.chime.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.chime.model.primitives.{
  Iso8601Timestamp,
  SensitiveString,
  EmailAddress
}
import scala.jdk.CollectionConverters._
final case class User(
    userId: String,
    accountId: Optional[String] = Optional.Absent,
    primaryEmail: Optional[EmailAddress] = Optional.Absent,
    primaryProvisionedNumber: Optional[SensitiveString] = Optional.Absent,
    displayName: Optional[SensitiveString] = Optional.Absent,
    licenseType: Optional[zio.aws.chime.model.License] = Optional.Absent,
    userType: Optional[zio.aws.chime.model.UserType] = Optional.Absent,
    userRegistrationStatus: Optional[zio.aws.chime.model.RegistrationStatus] =
      Optional.Absent,
    userInvitationStatus: Optional[zio.aws.chime.model.InviteStatus] =
      Optional.Absent,
    registeredOn: Optional[Iso8601Timestamp] = Optional.Absent,
    invitedOn: Optional[Iso8601Timestamp] = Optional.Absent,
    alexaForBusinessMetadata: Optional[
      zio.aws.chime.model.AlexaForBusinessMetadata
    ] = Optional.Absent,
    personalPIN: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.User
      .builder()
      .userId(userId: java.lang.String)
      .optionallyWith(accountId.map(value => value: java.lang.String))(
        _.accountId
      )
      .optionallyWith(
        primaryEmail.map(value => EmailAddress.unwrap(value): java.lang.String)
      )(_.primaryEmail)
      .optionallyWith(
        primaryProvisionedNumber.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.primaryProvisionedNumber)
      .optionallyWith(
        displayName.map(value =>
          SensitiveString.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(licenseType.map(value => value.unwrap))(_.licenseType)
      .optionallyWith(userType.map(value => value.unwrap))(_.userType)
      .optionallyWith(userRegistrationStatus.map(value => value.unwrap))(
        _.userRegistrationStatus
      )
      .optionallyWith(userInvitationStatus.map(value => value.unwrap))(
        _.userInvitationStatus
      )
      .optionallyWith(
        registeredOn.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.registeredOn)
      .optionallyWith(
        invitedOn.map(value => Iso8601Timestamp.unwrap(value): Instant)
      )(_.invitedOn)
      .optionallyWith(
        alexaForBusinessMetadata.map(value => value.buildAwsValue())
      )(_.alexaForBusinessMetadata)
      .optionallyWith(personalPIN.map(value => value: java.lang.String))(
        _.personalPIN
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.User.ReadOnly =
    zio.aws.chime.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.User] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.User = zio.aws.chime.model.User(
      userId,
      accountId.map(value => value),
      primaryEmail.map(value => value),
      primaryProvisionedNumber.map(value => value),
      displayName.map(value => value),
      licenseType.map(value => value),
      userType.map(value => value),
      userRegistrationStatus.map(value => value),
      userInvitationStatus.map(value => value),
      registeredOn.map(value => value),
      invitedOn.map(value => value),
      alexaForBusinessMetadata.map(value => value.asEditable),
      personalPIN.map(value => value)
    )
    def userId: String
    def accountId: Optional[String]
    def primaryEmail: Optional[EmailAddress]
    def primaryProvisionedNumber: Optional[SensitiveString]
    def displayName: Optional[SensitiveString]
    def licenseType: Optional[zio.aws.chime.model.License]
    def userType: Optional[zio.aws.chime.model.UserType]
    def userRegistrationStatus: Optional[zio.aws.chime.model.RegistrationStatus]
    def userInvitationStatus: Optional[zio.aws.chime.model.InviteStatus]
    def registeredOn: Optional[Iso8601Timestamp]
    def invitedOn: Optional[Iso8601Timestamp]
    def alexaForBusinessMetadata
        : Optional[zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly]
    def personalPIN: Optional[String]
    def getUserId: ZIO[Any, Nothing, String] = ZIO.succeed(userId)
    def getAccountId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getPrimaryEmail: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("primaryEmail", primaryEmail)
    def getPrimaryProvisionedNumber: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField(
        "primaryProvisionedNumber",
        primaryProvisionedNumber
      )
    def getDisplayName: ZIO[Any, AwsError, SensitiveString] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getLicenseType: ZIO[Any, AwsError, zio.aws.chime.model.License] =
      AwsError.unwrapOptionField("licenseType", licenseType)
    def getUserType: ZIO[Any, AwsError, zio.aws.chime.model.UserType] =
      AwsError.unwrapOptionField("userType", userType)
    def getUserRegistrationStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.RegistrationStatus] = AwsError
      .unwrapOptionField("userRegistrationStatus", userRegistrationStatus)
    def getUserInvitationStatus
        : ZIO[Any, AwsError, zio.aws.chime.model.InviteStatus] =
      AwsError.unwrapOptionField("userInvitationStatus", userInvitationStatus)
    def getRegisteredOn: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("registeredOn", registeredOn)
    def getInvitedOn: ZIO[Any, AwsError, Iso8601Timestamp] =
      AwsError.unwrapOptionField("invitedOn", invitedOn)
    def getAlexaForBusinessMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly
    ] = AwsError.unwrapOptionField(
      "alexaForBusinessMetadata",
      alexaForBusinessMetadata
    )
    def getPersonalPIN: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("personalPIN", personalPIN)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.User
  ) extends zio.aws.chime.model.User.ReadOnly {
    override val userId: String = impl.userId(): String
    override val accountId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => value: String)
    override val primaryEmail: Optional[EmailAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.primaryEmail())
      .map(value => zio.aws.chime.model.primitives.EmailAddress(value))
    override val primaryProvisionedNumber: Optional[SensitiveString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.primaryProvisionedNumber())
        .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val displayName: Optional[SensitiveString] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.chime.model.primitives.SensitiveString(value))
    override val licenseType: Optional[zio.aws.chime.model.License] =
      zio.aws.core.internal
        .optionalFromNullable(impl.licenseType())
        .map(value => zio.aws.chime.model.License.wrap(value))
    override val userType: Optional[zio.aws.chime.model.UserType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userType())
        .map(value => zio.aws.chime.model.UserType.wrap(value))
    override val userRegistrationStatus
        : Optional[zio.aws.chime.model.RegistrationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.userRegistrationStatus())
        .map(value => zio.aws.chime.model.RegistrationStatus.wrap(value))
    override val userInvitationStatus
        : Optional[zio.aws.chime.model.InviteStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.userInvitationStatus())
      .map(value => zio.aws.chime.model.InviteStatus.wrap(value))
    override val registeredOn: Optional[Iso8601Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredOn())
        .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val invitedOn: Optional[Iso8601Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.invitedOn())
      .map(value => zio.aws.chime.model.primitives.Iso8601Timestamp(value))
    override val alexaForBusinessMetadata
        : Optional[zio.aws.chime.model.AlexaForBusinessMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alexaForBusinessMetadata())
        .map(value => zio.aws.chime.model.AlexaForBusinessMetadata.wrap(value))
    override val personalPIN: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.personalPIN())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.User
  ): zio.aws.chime.model.User.ReadOnly = new Wrapper(impl)
}
