package zio.aws.chime.model
import zio.aws.chime.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserError(
    userId: Optional[NonEmptyString] = Optional.Absent,
    errorCode: Optional[zio.aws.chime.model.ErrorCode] = Optional.Absent,
    errorMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.chime.model.UserError = {
    import UserError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.chime.model.UserError
      .builder()
      .optionallyWith(
        userId.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.chime.model.UserError.ReadOnly =
    zio.aws.chime.model.UserError.wrap(buildAwsValue())
}
object UserError {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.chime.model.UserError] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.chime.model.UserError =
      zio.aws.chime.model.UserError(
        userId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def userId: Optional[NonEmptyString]
    def errorCode: Optional[zio.aws.chime.model.ErrorCode]
    def errorMessage: Optional[String]
    def getUserId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("userId", userId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.chime.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.chime.model.UserError
  ) extends zio.aws.chime.model.UserError.ReadOnly {
    override val userId: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.chime.model.primitives.NonEmptyString(value))
    override val errorCode: Optional[zio.aws.chime.model.ErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.chime.model.ErrorCode.wrap(value))
    override val errorMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.chime.model.UserError
  ): zio.aws.chime.model.UserError.ReadOnly = new Wrapper(impl)
}
